import React, { Component } from "react";

class MapContainer extends Component {
  constructor() {
    super();
    this.state = {
      map: null,
    };
  }

  componentDidMount() {
    this.initMap();
  }

  componentWillUnmount() {
    if (this.state.map) {
      this.state.map.destroy(); // 在组件卸载前移除地图
    }
  }

  initMap = () => {
    window.DiMapLoader.load({
      key: "", // 申请好的Web端开发者key
    })
      .then(({ DiMap }) => {
        const map = new DiMap.Map({
          container: "map", // 设置地图容器ID
          style: "dimap://styles/normal", // 设置地图的显示样式
          zoom: 11, // 初始化地图级别
          center: [116.397428, 39.90923], // 初始化地图中心点
        });

        map.on("load", () => {
          console.log("地图样式加载完成，可以安全添加图层");
          this.addMarker(map, DiMap);
          this.addPopup(map, DiMap);
          this.addPolyline(map, DiMap);
          this.addPolygon(map, DiMap);
        });

        map.on("click", (e) => {
          const lnglat = e.lngLat;
          console.log("你在" + lnglat + "点击了地图！");
        });

        map.on("mousemove", (e) => {
          const { lng, lat } = e.lngLat;
          console.log(`点击位置：${lng.toFixed(6)}, ${lat.toFixed(6)}`);
        });

        this.setState({ map });
      })
      .catch((err) => {
        console.error("地图初始化失败:", err);
      });
  };

  //添加标记点
  addMarker = (map, DiMap) => {
    const div = document.createElement("div");
    const img = document.createElement("img");
    const text = document.createElement("div");
    //设置容器样式
    div.style.width = "100px";
    div.style.height = "100px";
    div.style.display = "flex";
    div.style.flexDirection = "column";
    div.style.alignItems = "center";
    //设置图片样式
    img.style.width = "100%";
    img.style.height = "100%";
    img.src = "https://lbs.didistatic.com/dimap-web-opensdk-public/jsapi-demo/image/marker-icon.jpg"; //初始化标记图片地址
    //设置文字样式
    text.textContent = "标记点"; //设置文字内容
    text.style.color = "black";
    text.style.fontSize = "12px";

    const marker = new DiMap.Marker(div);
    div.appendChild(img);
    div.appendChild(text);
    marker.setLngLat([116.38267, 39.908179]); //初始化标记坐标
    marker.addTo(map); //将标记添加到地图
  };

  //添加消息弹窗
  addPopup = (map, DiMap) => {
    const popup = new DiMap.Popup()
      .setLngLat([116.3924, 39.94369]) //初始化弹窗坐标
      .setHTML(`<h1>Hello Popup</h1>`) //初始化弹窗内容
      .addTo(map); //将弹窗添加到地图
  };

  //添加线段
  addPolyline = (map, DiMap) => {
    const polyline = new DiMap.Polyline({
      map,
      path: [
        [116.35811, 39.90311],
        [116.36332, 39.89835],
        [116.37181, 39.89876],
        [116.37271, 39.90688],
      ], //初始化线段路径
      outlineColor: "#000000", // 外边框
      strokeColor: "#006600", // 外边框颜色
      strokeStyle: "solid", // 外边框类型
      lineCap: "butt", // 线两端线帽的样式,默认无头 butt
      lineJoin: "miter", // 线拐点连接处的样式，默认尖角 miter
      strokeWeight: 6, // 线宽度
      strokeOpacity: 1, // 线透明度
      borderWeight: 2, // 边框砍断
      isOutline: false, // 是否带边框
      showDir: true, // 是否显示方向箭头, 默认为 false
    });
    polyline.show();
  };

  //添加面
  addPolygon = (map, DiMap) => {
    const polygon = new DiMap.Polygon({
      map,
      path: [
        [
          [116.40231, 39.91336],
          [116.40191, 39.92319],
          [116.3915, 39.92292],
          [116.39218, 39.91306],
          [116.40231, 39.91336],
        ], //初始化面覆盖坐标，坐标前后需闭合
      ],
      fillColor: "red", //填充颜色
    });
    polygon.show();
  };

  render() {
    return <div id="map" style={{ width: "100%", height: "100vh" }} />;
  }
}

export default MapContainer;
