 # JSAPI-DEMO-React

## 一、项目启动说明

### 1. 安装依赖

请确保你已安装 [Node.js](https://nodejs.org/)（建议版本 16 及以上）。

在项目根目录下执行：

```bash
npm install
```

### 2. 启动开发环境

```bash
npm run dev
```

### 3. key 设置

请在滴图出行技术开放平台申请开发者 Key，并将其填入在 `src/MapContainer.jsx` 文件中的 `key` 字段：

  ```js
  window.DiMapLoader.load({
    key: "", // 申请好的Web端开发者Key
  })
  ```


### 4. jscode 设置

请在滴图出行技术开放平台申请安全密钥 jscode，并将其填入`index.html` 文件中的 `securityJsCode` 字段：

  ```html
  <script>
    window._DiMapSecurityConfig = {
      securityJsCode:"",  // 申请好的web端安全密钥
    };
  </script>
  ```

启动后，终端会输出本地访问地址 ，在浏览器中打开即可预览 Demo。

## 二、key、jscode 设置说明

在使用滴图出行技术开放平台所提供的 JS API 能力之前，需提前获取 key 和安全密钥。按照要求，在程序中添加 key 和安全密钥后才可使用各项地图能力。请登录[控制台](https://lbs.xiaojukeji.com/console)，点击工单咨询（右下角问号按钮）获取

- **注意：** key 和 jscode 必须与滴图出行技术开放平台申请时的域名、应用信息一致，否则地图无法正常加载。


## 三、功能列表

本 Demo 主要包含以下功能，均可在页面加载后体验：

1. **地图加载**  
   - 初始化并显示滴滴地图，设置中心点和缩放级别。
2. **标记点（Marker）**  
   - 在地图指定位置添加自定义标记点（可自定义图片和文字）。
3. **弹窗（Popup）**  
   - 在地图指定位置弹出信息窗口，支持自定义 HTML 内容。
4. **线段（Polyline）**  
   - 在地图上绘制多段折线，支持自定义颜色、宽度、透明度、箭头等样式。
5. **多边形（Polygon）**  
   - 在地图上绘制多边形区域，支持自定义填充颜色。
6. **地图事件监听**  
   - 支持点击、鼠标移动等事件，控制台可查看经纬度信息。
7. **地图销毁**  
   - 离开页面时自动销毁地图实例，释放资源。

---
[查看JSAPI线上 API 接口文档](https://lbs.xiaojukeji.com/console/docs/jsapi/apis/map/Map.html)