import React, { useEffect, useState } from "react";

const MapContainer = () => {
  const [map, setMap] = useState(null);
  const [dimapApi, setDimapApi] = useState(null); // 地图API资源缓存
  const COMMON_STYLE = "dimap://styles/normal";

  useEffect(() => {
    map?.destroy(); // 重复初始化地图实例之前，释放之前的地图实例
    initMap();
    return () => {
      map?.destroy(); // 组件卸载时销毁地图
    };
  }, []);

  const initMap = () => {
    // 利用保存的地图资源状态，避免重复加载地图资源
    if (dimapApi) {
      createMapInstance(dimapApi);
      return;
    }
    window.DiMapLoader.load({
      key: "", // 申请好的Web端开发者key
    })
      .then(({ DiMap }) => {
        setDimapApi(DiMap);
        createMapInstance(DiMap);
      })
      .catch((err) => {
        console.error("地图初始化失败:", err);
      });
  };

  const createMapInstance = (DiMap) => {
    const mapInstance = new DiMap.Map({
      container: "map", // 设置地图容器ID
      style: COMMON_STYLE, // 设置地图的显示样式
      zoom: 11, // 初始化地图级别
      center: [116.397428, 39.90923], // 初始化地图中心点
    });

    mapInstance.on("load", () => {
      console.log("地图样式加载完成");
      addMarker(mapInstance, DiMap);
      addPopup(mapInstance, DiMap);
      addPolyline(mapInstance, DiMap);
      addPolygon(mapInstance, DiMap);

      mapInstance.on("click", (e) => {
        const lnglat = e.lngLat;
        console.log("点击位置：" + lnglat);
      });

      mapInstance.on("mousemove", (e) => {
        const { lng, lat } = e.lngLat;
        console.log(`当前坐标：${lng.toFixed(6)}, ${lat.toFixed(6)}`);
      });
    });
    setMap(mapInstance);
  };

  // 添加标记点
  const addMarker = (mapInstance, DiMap) => {
    const div = document.createElement("div");
    const img = document.createElement("img");
    const text = document.createElement("div");
    // 设置容器样式
    div.style.width = "100px";
    div.style.height = "100px";
    div.style.display = "flex";
    div.style.flexDirection = "column";
    div.style.alignItems = "center";
    // 设置图片样式
    img.style.width = "100%";
    img.style.height = "100%";
    img.src = "https://lbs.didistatic.com/dimap-web-opensdk-public/jsapi-demo/image/marker-icon.jpg"; // 初始化标记图片地址
    // 设置文字样式
    text.textContent = "标记点"; // 设置文字内容
    text.style.color = "black";
    text.style.fontSize = "12px";

    const marker = new DiMap.Marker(div);
    div.appendChild(img);
    div.appendChild(text);
    marker.setLngLat([116.38267, 39.908179]); // 初始化标记坐标
    marker.addTo(mapInstance); // 将标记添加到地图
  };

  // 添加信息弹窗
  const addPopup = (mapInstance, DiMap) => {
    const popup = new DiMap.Popup()
      .setLngLat([116.3924, 39.94369]) // 初始化弹窗坐标
      .setHTML(`<h1>Hello Popup</h1>`) // 初始化弹窗内容
      .addTo(mapInstance); // 将弹窗添加到地图
  };

  // 添加线段
  const addPolyline = (mapInstance, DiMap) => {
    const polyline = new DiMap.Polyline({
      map: mapInstance,
      path: [
        [116.35811, 39.90311],
        [116.36332, 39.89835],
        [116.37181, 39.89876],
        [116.37271, 39.90688],
      ], // 初始化线段路径
      outlineColor: "#000000", // 外边框
      strokeColor: "#006600", // 外边框颜色
      strokeStyle: "solid", // 外边框类型
      lineCap: "butt", // 线两端线帽的样式,默认无头 butt
      lineJoin: "miter", // 线拐点连接处的样式，默认尖角 miter
      strokeWeight: 6, // 线宽度
      strokeOpacity: 1, // 线透明度
      borderWeight: 2, // 边框砍断
      isOutline: false, // 是否带边框
      showDir: true, // 是否显示方向箭头, 默认为 false
    });
    polyline.show(); // 展示线段
  };

  // 添加面
  const addPolygon = (mapInstance, DiMap) => {
    const polygon = new DiMap.Polygon({
      map: mapInstance,
      path: [
        [
          [116.40231, 39.91336],
          [116.40191, 39.92319],
          [116.3915, 39.92292],
          [116.39218, 39.91306],
          [116.40231, 39.91336],
        ], // 初始化面覆盖坐标，坐标前后需闭合
      ],
      fillColor: "red", // 填充颜色
    });
    polygon.show();
  };

  return <div id="map" style={{ width: "100%", height: "100vh" }} />;
};

export default MapContainer;
